
function timezone_init()
{
	timezone_showwatch();
	//document.getElementById("zone0").value = document.getElementById("normal").innerHTML;
	timezone_compute();
}

function timezone_getself()
{
	/* Code based on http://www.onlineaspect.com/2007/06/08/auto-detect-a-time-zone-with-javascript/ */
	var rightNow = new Date();
	var jan1 = new Date(rightNow.getFullYear(), 0, 1, 0, 0, 0, 0);  // jan 1st
	var temp = jan1.toGMTString();
	var jan2 = new Date(temp.substring(0, temp.lastIndexOf(" ")-1));

	var june1 = new Date(rightNow.getFullYear(), 6, 1, 0, 0, 0, 0); // june 1st
	temp = june1.toGMTString();
	var june2 = new Date(temp.substring(0, temp.lastIndexOf(" ")-1));

	var std_time_offset = (jan1 - jan2) / (1000 * 60 * 60);
	var daylight_time_offset = (june1 - june2) / (1000 * 60 * 60);
	var dst;

	if (std_time_offset == daylight_time_offset) {
		dst = 0; // daylight savings time is NOT observed
	} else {
		// positive is southern, negative is northern hemisphere
		var hemisphere = std_time_offset - daylight_time_offset;
		if (hemisphere >= 0)
			std_time_offset = daylight_time_offset;
		dst = 1; // daylight savings time is observed
	}
	return std_time_offset+dst;
}

function timezone_converttime(hr, mins, srcgmt, destgmt)
{
	var tmpout="";
	hr = (24+hr-srcgmt+destgmt)%24;
	if (hr < 10)
		tmpout = "0"+hr+":";
	else
		tmpout = hr+":";
	if (mins < 10)
		tmpout = tmpout+"0"+mins;
	else
		tmpout = tmpout+mins;

	return tmpout;
}

function timezone_error()
{
	document.getElementById("zone1").innerHTML="Invalid time";
	document.getElementById("zone2").innerHTML="Invalid time";
	return false;
}

function timezone_compute()
{
	var mins = 0;
	var hr = 0;
	var ctr = 0;
	var idx = 0;
	var digit;
	var temp = 0;
	var curchar;
	var curtimezone = parseInt(document.getElementById('gmtzone0').value);
	var tmpout;

	var strtime = document.getElementById("zone0").value;

	while (ctr < strtime.length) {
		curchar = strtime.charAt(ctr);
		if (isNaN(parseInt(curchar)) == false) {
			digit = parseInt(curchar);
			temp = temp*10 + digit;
		} else if (curchar != ':') {
			return timezone_error();
		} else {
			switch (idx)
			{
				case 0:
				{
					hr = temp;
					temp = 0;
					break;
				}
				case 1:
				{
					break;
				}
			}
			idx++;
		}
		ctr++;
	}
	if (idx == 0) {
		hr = temp;
	} else if (temp < 60) {
		mins = temp;
	} else {
		return timezone_error();
	}

	document.getElementById("zone0").value=timezone_converttime(hr,mins,0,0);
	document.getElementById("zone1").innerHTML=timezone_converttime(hr,mins,curtimezone,parseInt(document.getElementById('gmtzone1').value));
	document.getElementById("zone2").innerHTML=timezone_converttime(hr,mins,curtimezone,parseInt(document.getElementById('gmtzone2').value));
}


function timezone_showwatch()
{
	timezone_showtime();
	setTimeout("timezone_showwatch()",30000);
}

function timezone_showtime()
{
	var curtimezone = timezone_getself();
	var currentTime = new Date ();

	var currentHours = currentTime.getHours ();
	var currentMinutes = currentTime.getMinutes ();

	document.getElementById("normal").innerHTML= timezone_converttime(currentHours,currentMinutes,0,0);
	document.getElementById("clock0").innerHTML= timezone_converttime(currentHours,currentMinutes,curtimezone,parseInt(document.getElementById('gmtclock0').value));
	document.getElementById("clock1").innerHTML= timezone_converttime(currentHours,currentMinutes,curtimezone,parseInt(document.getElementById('gmtclock1').value));;
}

function timezone_display(curval, mode)
{
	document.write("UTC/GMT");
	if (curval == 0)
		return;
	if (curval > 0)
		document.write("+");
	document.write(curval);
}


function timezone_americaopt(curval)
{
	document.write("<option value=-9>Alaskan Standard Time (AKST)</option>");
	document.write("<option value=-8>Alaskan Daylight Time (AKDT)</option>");
	document.write("<option value=-4>Atlantic Standard Time (AST)</option>");
	document.write("<option value=-3>Atlantic Daylight Time (ADT)</option>");
	document.write("<option value=-6>Central Standard Time (CST)</option>");
	document.write("<option value=-5>Central Daylight Time (CDT)</option>");
	document.write("<option value=-5>Eastern Standard Time (EST)</option>");
	document.write("<option value=-4>Eastern Daylight Time (EDT)</option>");
	document.write("<option value=-10>Hawaiian Standard Time (HAST)</option>");
	document.write("<option value=-9>Hawaiian Daylight Time (HADT)</option>");
	document.write("<option value=-7>Mountain Standard Time (MST)</option>");
	document.write("<option value=-6>Mountain Daylight Time (MDT)</option>");
	document.write("<option value=-8>Pacific Standard Time (PST)</option>");
	document.write("<option value=-7>Pacific Daylight Time (PDT)</option>");
}

function timezone_gmtopt(curval)
{
	var i = -12;
	var modattr = i;
	while (i < 0) {
		if (curval == i)
			modattr=i;
		document.write("<option value="+i+">UTC/GMT"+i+"</option>");
		i = i + 1;
	}
	if (curval == i)
		modattr=i;
	document.write("<option value=0>UTC/GMT</option>");
	i = i + 1;
	while (i < 13) {
		if (curval == i)
			modattr=i;
		document.write("<option value="+i+">UTC/GMT+"+i+"</option>");
		i = i + 1;
	}
	return modattr+12;
}


function timezone_showallgmt(curval, idval, chgaction)
{
	var selval;
	
	document.write("<select id="+idval+" onchange='"+chgaction+"'>");
	selval = timezone_gmtopt(curval);
	document.write("</select>");
	document.getElementById(idval).selectedIndex=selval;
}

function timezone_showallamerican(curval, idval, chgaction)
{
	document.write("<select id="+idval+" onchange='"+chgaction+"'>");
	timezone_americaopt(curval);
	document.write("</select>");
}


function timezone_showall(curval, idval, chgaction)
{
	document.write("<select id="+idval+" onchange='"+chgaction+"'>");
	timezone_americaopt(curval);
	// 14=Total so far
	selval = timezone_gmtopt(curval)+14;
	document.write("</select>");
}
